<?php

// Skin
$this->sections[] = $this->add_customizer_field(
	array(
		'icon'       => 'icon-visual',
		'icon_class' => 'porto-icon',
		'title'      => __( 'Skin', 'porto' ),
	),
	$options_style
);
$this->sections[] = array(
	'title'      => __( 'Theme Colors', 'porto' ),
	'id'         => 'skin-theme-colors',
	'subsection' => true,
	'transport'  => 'postMessage',
	'fields'     => array(
		array(
			'id'       => 'css-type',
			'type'     => 'button_set',
			'title'    => __( 'Color Scheme', 'porto' ),
			'subtitle' => __( 'Controls the theme skin to be light or dark style.', 'porto' ),
			'options'  => array(
				''     => array(
                    'label' => __( 'Light', 'porto' ),
                    'hint'  => array(
                        'content' => esc_html( '<img src="' . PORTO_HINT_URL . 'css-type.jpg"/>' ),
                    ),
                ),
				'dark' => array(
                    'label' => __( 'Dark', 'porto' ),
                    'hint'  => array(
                        'content' => esc_html( '<img src="' . PORTO_HINT_URL . 'css-type-dark.jpg"/>' ),
                    ),
                ),
			),
			'default'  => '',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'color-dark',
			'type'     => 'color',
			'required' => array( 'css-type', 'equals', 'dark' ),
			'title'    => __( 'Basic Background Color', 'porto' ),
			'subtitle' => __( 'Controls the skin color for dark theme.', 'porto' ),
			'default'  => '#1d2127',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'skin-color',
			'type'     => 'color',
			'title'    => __( 'Primary Color', 'porto' ),
			'subtitle' => __( 'Controls the main color throughout the theme.', 'porto' ),
			'default'  => '#0088cc',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'skin-color-inverse',
			'type'     => 'color',
			'title'    => __( 'Primary Inverse Color', 'porto' ),
			'subtitle' => __( 'Controls the inverse color of main color throughout the theme.', 'porto' ),
			'desc'     => __( 'Hover, focus and active color of primary color.', 'porto' ),
			'default'  => '#ffffff',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'secondary-color',
			'type'     => 'color',
			'title'    => __( 'Secondary Color', 'porto' ),
			'subtitle' => __( 'Controls the secondary color throughout the theme.', 'porto' ),
			'default'  => '#e36159',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'secondary-color-inverse',
			'type'     => 'color',
			'title'    => __( 'Secondary Inverse Color', 'porto' ),
			'subtitle' => __( 'Controls the inverse color of secondary color throughout the theme.', 'porto' ),
			'desc'     => __( 'Hover, focus and active color of secondary color.', 'porto' ),
			'default'  => '#ffffff',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'tertiary-color',
			'type'     => 'color',
			'title'    => __( 'Tertiary Color', 'porto' ),
			'subtitle' => __( 'Controls the tertiary color throughout the theme.', 'porto' ),
			'default'  => '#2baab1',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'tertiary-color-inverse',
			'type'     => 'color',
			'title'    => __( 'Tertiary Inverse Color', 'porto' ),
			'subtitle' => __( 'Controls the inverse color of tertiary color throughout the theme.', 'porto' ),
			'desc'     => __( 'Hover, focus and active color of tertiary color.', 'porto' ),
			'default'  => '#ffffff',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'quaternary-color',
			'type'     => 'color',
			'title'    => __( 'Quaternary Color', 'porto' ),
			'subtitle' => __( 'Controls the quaternary color throughout the theme.', 'porto' ),
			'default'  => '#383f48',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'quaternary-color-inverse',
			'type'     => 'color',
			'title'    => __( 'Quaternary Inverse Color', 'porto' ),
			'subtitle' => __( 'Controls the inverse color of quaternary color throughout the theme.', 'porto' ),
			'desc'     => __( 'Hover, focus and active color of quaternary color.', 'porto' ),
			'default'  => '#ffffff',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'dark-color',
			'type'     => 'color',
			'title'    => __( 'Dark Color', 'porto' ),
			'subtitle' => __( 'Controls the dark color throughout the theme.', 'porto' ),
			'default'  => '#212529',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'dark-color-inverse',
			'type'     => 'color',
			'title'    => __( 'Dark Inverse Color', 'porto' ),
			'subtitle' => __( 'Controls the dark color of quaternary color throughout the theme.', 'porto' ),
			'desc'     => __( 'Hover, focus and active color of dark color.', 'porto' ),
			'default'  => '#ffffff',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'light-color',
			'type'     => 'color',
			'title'    => __( 'Light Color', 'porto' ),
			'subtitle' => __( 'Controls the light color throughout the theme.', 'porto' ),
			'default'  => '#ffffff',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'light-color-inverse',
			'type'     => 'color',
			'title'    => __( 'Light Inverse Color', 'porto' ),
			'subtitle' => __( 'Controls the light color of quaternary color throughout the theme.', 'porto' ),
			'desc'     => __( 'Hover, focus and active color of light color.', 'porto' ),
			'default'  => '#212529',
			'validate' => 'color',
			'compiler' => true,
			'selector' => array(
				'node' => ':root',
			),
		),
		array(
			'id'       => 'placeholder-color',
			'type'     => 'color',
			'title'    => __( 'Placeholder Image Background Color', 'porto' ),
			'subtitle' => __( 'Controls the skeleton color throughout the theme.', 'porto' ),
			'default'  => '#f4f4f4',
			'validate' => 'color',
			'hint'     => array(
				'content' => esc_html( '<img src="' . PORTO_HINT_URL . 'placeholder-color.gif"/>' ),
			),
			'compiler' => true,
		),
		array(
			'id'       => 'social-color',
			'type'     => 'button_set',
			'title'    => __( 'Social Links Color', 'porto' ),
			'subtitle' => __( 'If you select "primary" option, social links will be determined by Primary and Primary Inverse color.', 'porto' ),
			'options'  => array(
				''        => array(
                    'label' => __( 'Default', 'porto' ),
                    'hint'  => array(
                        'content' => esc_html( '<img src="' . PORTO_HINT_URL . 'social-color.jpg"/>' ),
                    ),
                ),
				'primary' => array(
                    'label' => __( 'Primary Color', 'porto' ),
                    'hint'  => array(
                        'content' => esc_html( '<img src="' . PORTO_HINT_URL . 'social-color-primary.jpg"/>' ),
                    ),
                ),
			),
			'default'  => '',
			'compiler' => true,
		),
	),
);

// Skin Typography
if ( $this->legacy_mode ) {
	$this->sections[] = array(
		'icon_class' => 'icon',
		'subsection' => true,
		'title'      => __( 'Typography', 'porto' ),
		'fields'     => array(
			array(
				'id'       => 'select-google-charset',
				'type'     => 'switch',
				'title'    => __( 'Select Google Font Character Sets', 'porto' ),
				'subtitle' => __( 'Select "YES" to set the subsets of Google fonts.', 'porto' ),
				'default'  => false,
				'on'       => __( 'Yes', 'porto' ),
				'off'      => __( 'No', 'porto' ),
			),
			array(
				'id'       => 'google-charsets',
				'type'     => 'button_set',
				'title'    => __( 'Google Font Character Sets', 'porto' ),
				'multi'    => true,
				'required' => array( 'select-google-charset', 'equals', true ),
				'options'  => array(
					'cyrillic'     => 'Cyrrilic',
					'cyrillic-ext' => 'Cyrrilic Extended',
					'greek'        => 'Greek',
					'greek-ext'    => 'Greek Extended',
					'khmer'        => 'Khmer',
					'latin'        => 'Latin',
					'latin-ext'    => 'Latin Extended',
					'vietnamese'   => 'Vietnamese',
				),
				'default'  => array( 'latin', 'greek-ext', 'cyrillic', 'latin-ext', 'greek', 'cyrillic-ext', 'vietnamese', 'khmer' ),
			),
			array(
				'id'      => 'google-webfont-loader',
				'type'    => 'switch',
				'title'   => __( 'Enable Web Font Loader for Google Fonts', 'porto' ),
				/* translators: $1: opening A tag which has link to the Google PageSpeed Insights $2: closing A tag */
				'desc'    => sprintf( esc_html__( 'By using this option, you can increase page speed about 4 percent in %1$sGoogle PageSpeed Insights%2$s for both of mobile and desktop.', 'porto' ), '<a href="https://developers.google.com/speed/pagespeed/insights/" target="_blank" rel="noopener noreferrer">', '</a>' ),
				'default' => true,
				'on'      => __( 'Yes', 'porto' ),
				'off'     => __( 'No', 'porto' ),
			),
			array(
				'id'             => 'body-font',
				'type'           => 'typography',
				'title'          => __( 'Body Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all body text.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'compiler'       => true,
				'default'        => array(
					'color'          => '#777777',
					'google'         => true,
					'font-weight'    => '400',
					'font-family'    => 'Poppins',
					'font-size'      => '14px',
					'line-height'    => '24px',
					'letter-spacing' => '0',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => ':root',
				),
			),
			array(
				'id'             => 'body-mobile-font',
				'type'           => 'typography',
				'title'          => __( 'Body Mobile Font', 'porto' ),
				'subtitle'       => __( 'Controls the mobile typography for all body text.', 'porto' ),
				'google'         => false,
				'subsets'        => false,
				'font-family'    => false,
				'font-weight'    => false,
				'text-align'     => false,
				'color'          => false,
				'font-style'     => false,
				'letter-spacing' => true,
				'desc'           => __( 'Will be change on mobile device(max width < 576px).', 'porto' ),
				'default'        => array(
					'font-size'      => '13px',
					'line-height'    => '22px',
					'letter-spacing' => '0',
				),
			),
			array(
				'id'          => 'alt-font',
				'type'        => 'typography',
				'title'       => __( 'Alternative Font', 'porto' ),
				'subtitle'    => __( 'Used in some elements and footer ribbon text.', 'porto' ),
				'google'      => true,
				'subsets'     => false,
				'font-style'  => false,
				'font-size'   => false,
				'text-align'  => false,
				'color'       => false,
				'line-height' => false,
				'desc'        => __( 'You can use css class name "alternative-font" when edit html element.', 'porto' ),
				'default'     => array(
					'google'      => true,
					'font-weight' => '400',
					'font-family' => 'Shadows Into Light',
				),
				'transport'   => 'postMessage',
				'selector'    => array(
					'node' => ':root',
				),
			),
			array(
				'id'             => 'h1-font',
				'type'           => 'typography',
				'title'          => __( 'H1 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H1 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '36px',
					'line-height'    => '44px',
					'letter-spacing' => '',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => 'h1',
				),
			),
			array(
				'id'             => 'h2-font',
				'type'           => 'typography',
				'title'          => __( 'H2 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H2 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '30px',
					'line-height'    => '40px',
					'letter-spacing' => '',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => 'h2',
				),
			),
			array(
				'id'             => 'h3-font',
				'type'           => 'typography',
				'title'          => __( 'H3 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H3 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '25px',
					'line-height'    => '32px',
					'letter-spacing' => '',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => 'h3, .daily-deal-title',
				),
			),
			array(
				'id'             => 'h4-font',
				'type'           => 'typography',
				'title'          => __( 'H4 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H4 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '20px',
					'line-height'    => '27px',
					'letter-spacing' => '',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => 'h4',
				),
			),
			array(
				'id'             => 'h5-font',
				'type'           => 'typography',
				'title'          => __( 'H5 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H5 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '18px',
					'letter-spacing' => '',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => 'h5',
				),
			),
			array(
				'id'             => 'h6-font',
				'type'           => 'typography',
				'title'          => __( 'H6 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H6 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '18px',
					'letter-spacing' => '',
				),
				'transport'      => 'postMessage',
				'selector'       => array(
					'node' => 'h6',
				),
			),
			array(
				'id'             => 'paragraph-font',
				'type'           => 'typography',
				'title'          => __( 'Paragraph Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all p tags.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
			),
			array(
				'id'             => 'footer-font',
				'type'           => 'typography',
				'title'          => __( 'Footer Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all footer text.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
			),
			array(
				'id'             => 'footer-heading-font',
				'type'           => 'typography',
				'title'          => __( 'Footer Heading Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all footer heading tags (h1 ~ h6).', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'font-size'      => false,
				'line-height'    => false,
				'letter-spacing' => true,
			),
			array(
				'id'             => 'shortcode-testimonial-font',
				'type'           => 'typography',
				'title'          => __( 'Testimonial Shortcode Font', 'porto' ),
				'subtitle'       => __( 'Controls the testimonial text for the testimonial element.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'color'          => false,
				'font-size'      => false,
				'font-style'     => false,
				'font-weight'    => false,
				'text-align'     => false,
				'line-height'    => false,
				'letter-spacing' => true,
				'default'        => array(
					'google'      => true,
					'font-family' => 'Playfair Display',
				),
				'transport'      => 'postMessage',
			),
			array(
				'title'          => esc_html__( 'Custom Font 1', 'porto' ),
				'subtitle'       => __( 'Controls a custom font to use throughout the site.', 'porto' ),
				'desc'           => esc_html__( 'You can use this font in some shortcodes such as heading and icon box. Please use "custom-font1" css class to use this font.', 'porto' ),
				'id'             => 'custom1-font',
				'type'           => 'typography',
				'google'         => true,
				'font-style'     => false,
				'font-weight'    => true,
				'text-align'     => false,
				'font-size'      => false,
				'color'          => false,
				'line-height'    => false,
				'letter-spacing' => false,
				'subsets'        => false,
			),
			array(
				'title'          => esc_html__( 'Custom Font 2', 'porto' ),
				'subtitle'       => __( 'Controls a custom font to use throughout the site.', 'porto' ),
				'desc'           => esc_html__( 'You can use this font in some shortcodes such as heading and icon box. Please use "custom-font2" css class to use this font.', 'porto' ),
				'id'             => 'custom2-font',
				'type'           => 'typography',
				'google'         => true,
				'font-style'     => false,
				'font-weight'    => true,
				'text-align'     => false,
				'font-size'      => false,
				'color'          => false,
				'line-height'    => false,
				'letter-spacing' => false,
				'subsets'        => false,
			),
			array(
				'title'          => esc_html__( 'Custom Font 3', 'porto' ),
				'subtitle'       => __( 'Controls a custom font to use throughout the site.', 'porto' ),
				'desc'           => esc_html__( 'You can use this font in some shortcodes such as heading and icon box. Please use "custom-font3" css class to use this font.', 'porto' ),
				'id'             => 'custom3-font',
				'type'           => 'typography',
				'google'         => true,
				'font-style'     => false,
				'font-weight'    => true,
				'text-align'     => false,
				'font-size'      => false,
				'color'          => false,
				'line-height'    => false,
				'letter-spacing' => false,
				'subsets'        => false,
			),
		),
	);
} else {
	$this->sections[] = array(
		'icon_class' => 'icon',
		'subsection' => true,
		'title'      => __( 'Typography', 'porto' ),
		'fields'     => array(
			array(
				'id'      => 'select-google-charset',
				'type'    => 'switch',
				'title'   => __( 'Select Google Font Character Sets', 'porto' ),
				'subtitle' => __( 'Select "YES" to set the subsets of Google fonts.', 'porto' ),
				'default' => false,
				'on'      => __( 'Yes', 'porto' ),
				'off'     => __( 'No', 'porto' ),
			),
			array(
				'id'       => 'google-charsets',
				'type'     => 'button_set',
				'title'    => __( 'Google Font Character Sets', 'porto' ),
				'multi'    => true,
				'required' => array( 'select-google-charset', 'equals', true ),
				'options'  => array(
					'cyrillic'     => 'Cyrrilic',
					'cyrillic-ext' => 'Cyrrilic Extended',
					'greek'        => 'Greek',
					'greek-ext'    => 'Greek Extended',
					'khmer'        => 'Khmer',
					'latin'        => 'Latin',
					'latin-ext'    => 'Latin Extended',
					'vietnamese'   => 'Vietnamese',
				),
				'default'  => array( 'latin', 'greek-ext', 'cyrillic', 'latin-ext', 'greek', 'cyrillic-ext', 'vietnamese', 'khmer' ),
			),
			array(
				'id'      => 'google-webfont-loader',
				'type'    => 'switch',
				'title'   => __( 'Enable Web Font Loader for Google Fonts', 'porto' ),
				/* translators: $1: opening A tag which has link to the Google PageSpeed Insights $2: closing A tag */
				'desc'    => sprintf( esc_html__( 'By using this option, you can increase page speed about 4 percent in %1$sGoogle PageSpeed Insights%2$s for both of mobile and desktop.', 'porto' ), '<a href="https://developers.google.com/speed/pagespeed/insights/" target="_blank" rel="noopener noreferrer">', '</a>' ),
				'default' => true,
				'on'      => __( 'Yes', 'porto' ),
				'off'     => __( 'No', 'porto' ),
			),
			array(
				'id'             => 'body-font',
				'type'           => 'typography',
				'title'          => __( 'Body Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all body text.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'compiler'       => true,
				'default'        => array(
					'color'          => '#777777',
					'google'         => true,
					'font-weight'    => '400',
					'font-family'    => 'Poppins',
					'font-size'      => '14px',
					'line-height'    => '24px',
					'letter-spacing' => '0',
				),
				'selector'       => array(
					'node' => ':root',
				),
			),
			array(
				'id'             => 'body-mobile-font',
				'type'           => 'typography',
				'title'          => __( 'Body Mobile Font', 'porto' ),
				'subtitle'       => __( 'Controls the mobile typography for all body text.', 'porto' ),
				'google'         => false,
				'subsets'        => false,
				'font-family'    => false,
				'font-weight'    => false,
				'text-align'     => false,
				'color'          => false,
				'font-style'     => false,
				'letter-spacing' => true,
				'desc'           => __( 'Will be change on mobile device(max width < 576px).', 'porto' ),
				'default'        => array(
					'font-size'      => '13px',
					'line-height'    => '20px',
					'letter-spacing' => '0',
				),
			),
			array(
				'id'          => 'alt-font',
				'type'        => 'typography',
				'title'       => __( 'Alternative Font', 'porto' ),
				'subtitle'    => __( 'Used in some elements and footer ribbon text.', 'porto' ),
				'google'      => true,
				'subsets'     => false,
				'font-style'  => false,
				'font-size'   => false,
				'text-align'  => false,
				'color'       => false,
				'line-height' => false,
				'desc'        => __( 'You can use css class name "alternative-font" when edit html element.', 'porto' ),
				'default'     => array(
					'google'      => true,
					'font-weight' => '400',
					'font-family' => 'Shadows Into Light',
				),
				'selector'    => array(
					'node' => ':root',
				),
			),
			array(
				'id'             => 'h1-font',
				'type'           => 'typography',
				'title'          => __( 'H1 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H1 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '36px',
					'line-height'    => '44px',
					'letter-spacing' => '',
				),
				'selector'       => array(
					'node' => 'h1',
				),
			),
			array(
				'id'             => 'h2-font',
				'type'           => 'typography',
				'title'          => __( 'H2 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H2 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '30px',
					'line-height'    => '40px',
					'letter-spacing' => '',
				),
				'selector'       => array(
					'node' => 'h2',
				),
			),
			array(
				'id'             => 'h3-font',
				'type'           => 'typography',
				'title'          => __( 'H3 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H3 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '25px',
					'line-height'    => '32px',
					'letter-spacing' => '',
				),
				'selector'       => array(
					'node' => 'h3',
				),
			),
			array(
				'id'             => 'h4-font',
				'type'           => 'typography',
				'title'          => __( 'H4 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H4 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '20px',
					'line-height'    => '27px',
					'letter-spacing' => '',
				),
				'selector'       => array(
					'node' => 'h4',
				),
			),
			array(
				'id'             => 'h5-font',
				'type'           => 'typography',
				'title'          => __( 'H5 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H5 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '18px',
					'letter-spacing' => '',
				),
				'selector'       => array(
					'node' => 'h5',
				),
			),
			array(
				'id'             => 'h6-font',
				'type'           => 'typography',
				'title'          => __( 'H6 Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all H6 headings.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
				'default'        => array(
					'color'          => '',
					'google'         => true,
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '18px',
					'letter-spacing' => '',
				),
				'selector'       => array(
					'node' => 'h6',
				),
			),
			array(
				'id'             => 'paragraph-font',
				'type'           => 'typography',
				'title'          => __( 'Paragraph Font', 'porto' ),
				'subtitle'       => __( 'Controls the typography for all p tags.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'font-style'     => false,
				'text-align'     => false,
				'letter-spacing' => true,
			),
			array(
				'id'             => 'shortcode-testimonial-font',
				'type'           => 'typography',
				'title'          => __( 'Testimonial Shortcode Font', 'porto' ),
				'subtitle'       => __( 'Controls the testimonial text for the testimonial element.', 'porto' ),
				'google'         => true,
				'subsets'        => false,
				'color'          => false,
				'font-size'      => false,
				'font-style'     => false,
				'font-weight'    => false,
				'text-align'     => false,
				'line-height'    => false,
				'letter-spacing' => true,
				'default'        => array(
					'google'      => true,
					'font-family' => 'Playfair Display',
				),
			),
			array(
				'title'          => esc_html__( 'Custom Font 1', 'porto' ),
				'subtitle'       => __( 'Controls a custom font to use throughout the site.', 'porto' ),
				'desc'           => esc_html__( 'You can use this font in some shortcodes such as heading and icon box. Please use "custom-font1" css class to use this font.', 'porto' ),
				'id'             => 'custom1-font',
				'type'           => 'typography',
				'google'         => true,
				'font-style'     => false,
				'font-weight'    => true,
				'text-align'     => false,
				'font-size'      => false,
				'color'          => false,
				'line-height'    => false,
				'letter-spacing' => false,
				'subsets'        => false,
			),
			array(
				'title'          => esc_html__( 'Custom Font 2', 'porto' ),
				'subtitle'       => __( 'Controls a custom font to use throughout the site.', 'porto' ),
				'desc'           => esc_html__( 'You can use this font in some shortcodes such as heading and icon box. Please use "custom-font2" css class to use this font.', 'porto' ),
				'id'             => 'custom2-font',
				'type'           => 'typography',
				'google'         => true,
				'font-style'     => false,
				'font-weight'    => true,
				'text-align'     => false,
				'font-size'      => false,
				'color'          => false,
				'line-height'    => false,
				'letter-spacing' => false,
				'subsets'        => false,
			),
			array(
				'title'          => esc_html__( 'Custom Font 3', 'porto' ),
				'subtitle'       => __( 'Controls a custom font to use throughout the site.', 'porto' ),
				'desc'           => esc_html__( 'You can use this font in some shortcodes such as heading and icon box. Please use "custom-font3" css class to use this font.', 'porto' ),
				'id'             => 'custom3-font',
				'type'           => 'typography',
				'google'         => true,
				'font-style'     => false,
				'font-weight'    => true,
				'text-align'     => false,
				'font-size'      => false,
				'color'          => false,
				'line-height'    => false,
				'letter-spacing' => false,
				'subsets'        => false,
			),
		),
	);
}

if ( $this->legacy_mode ) {
	$this->sections[] = array(
		'icon_class' => 'icon',
		'subsection' => true,
		'title'      => __( 'Backgrounds', 'porto' ),
		'transport'  => 'postMessage',
		'fields'     => array(
			array(
				'id'     => 'desc_info_bodybg',
				'type'   => 'info',
				'title'  => __( 'Body Background', 'porto' ),
				'notice' => false,
			),
			array(
				'id'       => 'body-bg',
				'type'     => 'background',
				'title'    => __( 'Background', 'porto' ),
				'subtitle' => __( 'Controls the background settings for body.', 'porto' ),
			),
			array(
				'id'       => 'body-bg-gradient',
				'type'     => 'switch',
				'title'    => __( 'Enable Background Gradient', 'porto' ),
				'subtitle' => __( 'Controls the background gradient settings of body.', 'porto' ),
				'default'  => false,
				'on'       => __( 'Yes', 'porto' ),
				'off'      => __( 'No', 'porto' ),
			),
			array(
				'id'       => 'body-bg-gcolor',
				'type'     => 'color_gradient',
				'title'    => __( 'Background Gradient Color', 'porto' ),
				'subtitle' => __( 'Controls the top and bottom background color of body.', 'porto' ),
				'required' => array( 'body-bg-gradient', 'equals', true ),
				'default'  => array(
					'from' => '',
					'to'   => '',
				),
			),
			array(
				'id'     => 'desc_info_content_bg',
				'type'   => 'info',
				'title'  => __( 'Page Content Background', 'porto' ),
				'notice' => false,
			),
			array(
				'id'       => 'content-bg',
				'type'     => 'background',
				'title'    => __( 'Background', 'porto' ),
				'subtitle' => __( 'Controls the background settings for page content.', 'porto' ),
			),
			array(
				'id'       => 'content-bg-gradient',
				'type'     => 'switch',
				'title'    => __( 'Enable Background Gradient', 'porto' ),
				'subtitle' => __( 'Controls the background gradient settings of page content.', 'porto' ),
				'default'  => false,
				'on'       => __( 'Yes', 'porto' ),
				'off'      => __( 'No', 'porto' ),
			),
			array(
				'id'       => 'content-bg-gcolor',
				'type'     => 'color_gradient',
				'title'    => __( 'Background Gradient Color', 'porto' ),
				'subtitle' => __( 'Controls the top and bottom background color of page content.', 'porto' ),
				'required' => array( 'content-bg-gradient', 'equals', true ),
				'default'  => array(
					'from' => '',
					'to'   => '',
				),
			),
			array(
				'id'     => 'desc_info_content_bottom',
				'type'   => 'info',
				'title'  => __( 'Content Bottom Widgets Area : For this options, you should build one more Content Bottom Widget.', 'porto' ),
				'notice' => false,
			),
			array(
				'id'       => 'content-bottom-bg',
				'type'     => 'background',
				'title'    => __( 'Background', 'porto' ),
				'subtitle' => __( 'Controls the background settings for content bottom widget.', 'porto' ),
			),
			array(
				'id'       => 'content-bottom-bg-gradient',
				'type'     => 'switch',
				'title'    => __( 'Enable Background Gradient', 'porto' ),
				'subtitle' => __( 'Controls the background gradient settings of content bottom content.', 'porto' ),
				'default'  => false,
				'on'       => __( 'Yes', 'porto' ),
				'off'      => __( 'No', 'porto' ),
			),
			array(
				'id'       => 'content-bottom-bg-gcolor',
				'type'     => 'color_gradient',
				'title'    => __( 'Background Gradient Color', 'porto' ),
				'subtitle' => __( 'Controls the top and bottom background color of content bottom widget.', 'porto' ),
				'required' => array( 'content-bottom-bg-gradient', 'equals', true ),
				'default'  => array(
					'from' => '',
					'to'   => '',
				),
			),
			array(
				'id'       => 'content-bottom-padding',
				'type'     => 'spacing',
				'mode'     => 'padding',
				'title'    => __( 'Padding', 'porto' ),
				'subtitle' => __( 'Controls the padding of content bottom widget.', 'porto' ),
				'default'  => array(
					'padding-top'    => 0,
					'padding-bottom' => 20,
				),
			),
		),
	);
}

$this->sections[] = array(
	'icon_class' => 'icon',
	'subsection' => true,
	'title'      => __( 'Form Style', 'porto' ),
	'transport'  => 'postMessage',
	'fields'     => array(
		array(
			'id'       => 'form-ih',
			'type'     => 'text',
			'title'    => __( 'The Height of input and select box', 'porto' ),
			'subtitle' => __( 'Enter value including any valid CSS unit, ex: 30px.', 'porto' ),
			'default'  => '',
		),
		array(
			'id'       => 'form-fs',
			'type'     => 'text',
			'title'    => __( 'Form Font Size', 'porto' ),
			'subtitle' => __( 'Inputs the font size of form and form fields.', 'porto' ),
			'default'  => '',
		),
		array(
			'id'       => 'form-color',
			'type'     => 'color',
			'title'    => __( 'Form Text Color', 'porto' ),
			'subtitle' => __( 'Controls the color of the form and form fields.', 'porto' ),
			'default'  => '',
			'validate' => 'color',
		),
		array(
			'id'       => 'form-field-bgc',
			'type'     => 'color',
			'title'    => __( 'Form Field Background Color', 'porto' ),
			'subtitle' => __( 'Controls the background color of form fields such as input and select boxes.', 'porto' ),
			'default'  => '',
			'validate' => 'color',
		),
		array(
			'id'       => 'form-field-bw',
			'type'     => 'spacing',
			'mode'     => 'border',
			'title'    => __( 'Form Field Border Width (px)', 'porto' ),
			'subtitle' => __( 'Controls the border size of the form fields such as input and select boxes.', 'porto' ),
			'units'    => 'px',
		),
		array(
			'id'       => 'form-field-bc',
			'type'     => 'color',
			'title'    => __( 'Form Field Border Color', 'porto' ),
			'subtitle' => __( 'Controls the border color of form fields such as input and select boxes.', 'porto' ),
			'default'  => '',
			'validate' => 'color',
		),
		array(
			'id'       => 'form-field-bcf',
			'type'     => 'color',
			'title'    => __( 'Form Field Border Color on Focus', 'porto' ),
			'subtitle' => __( 'Controls the border color of form fields such as input and select boxes on focus status.', 'porto' ),
			'default'  => '',
			'validate' => 'color',
		),
		array(
			'id'       => 'form-br',
			'type'     => 'text',
			'title'    => __( 'Form Border Radius', 'porto' ),
			'subtitle' => __( 'Controls the border radius of form fields such as input, select boxes and buttons. Enter value including any valid CSS unit, ex: 30px.', 'porto' ),
		),
	),
);
