<?php
/**
 * Related Products
 *
 * @version     9.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product, $porto_settings, $porto_product_layout;

if ( empty( $product ) || ! $product->exists() ) {
	return;
}
$related = wc_get_related_products( $product->get_id(), ! empty( $porto_settings['product-related-count'] ) ? $porto_settings['product-related-count'] : 5 );
if ( sizeof( $related ) === 0 || ( apply_filters( 'porto_legacy_mode', true ) && empty( $porto_settings['product-related'] ) ) ) {
	return;
}

$args = apply_filters(
	'woocommerce_related_products_args',
	array(
		'post_type'           => 'product',
		'ignore_sticky_posts' => 1,
		'no_found_rows'       => 1,
		'posts_per_page'      => isset( $porto_settings['product-related-count'] ) ? $porto_settings['product-related-count'] : '10',
		'orderby'             => $orderby,
		'post__in'            => $related,
		'post__not_in'        => array( $product->get_id() ),
	)
);

$products = new WP_Query( $args );

if ( 'left_sidebar' == $porto_product_layout ) {
	$container_class = '';
} elseif ( porto_is_wide_layout() ) {
	$container_class = 'container-fluid';
} else {
	$container_class = 'container';
}

if ( $products->have_posts() ) :
	global $porto_woocommerce_loop;

	$porto_woocommerce_loop['columns'] = isset( $porto_settings['product-related-cols'] ) ? $porto_settings['product-related-cols'] : ( isset( $porto_settings['product-cols'] ) ? $porto_settings['product-cols'] : 3 );

	if ( ! $porto_woocommerce_loop['columns'] ) {
		$porto_woocommerce_loop['columns'] = 4;
	}

	?>
	<div class="related products">
		<div class="<?php echo esc_attr( $container_class ); ?>">
			<?php
				$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );

			if ( $heading ) :
				?>
				<h2 class="slider-title"><?php echo esc_html( $heading ); ?></h2>
			<?php endif; ?>

			<div class="slider-wrapper">

				<?php
				$porto_woocommerce_loop['view']       = 'products-slider';
				$porto_woocommerce_loop['navigation'] = false;
				$porto_woocommerce_loop['pagination'] = true;
				$porto_woocommerce_loop['el_class']   = 'show-dots-title-right dots-style-1';

				woocommerce_product_loop_start();
				?>

				<?php
				while ( $products->have_posts() ) :
					$products->the_post();
					?>

					<?php wc_get_template_part( 'content', 'product' ); ?>

				<?php endwhile; // end of the loop. ?>

				<?php
				woocommerce_product_loop_end();
				?>
			</div>
		</div>
	</div>
	<?php
endif;

wp_reset_postdata();
